﻿namespace Microsoft.Samples.PlanMyNight.AddIns.Share.Models
{
    using System;
    using System.ComponentModel.Composition;
    using System.Globalization;
    using System.IO;
    using System.Net;
    using System.Text;
    using System.Web;
    using Microsoft.Samples.PlanMyNight.AddIns.Share.Properties;

    [Export(typeof(IShortenUrlService))]
    [PartCreationPolicy(CreationPolicy.NonShared)]
    public class TinyUrlService : IShortenUrlService
    {
        public Uri GeneratedShortUrl(string longUrl)
        {
            string requestUrl = string.Format(CultureInfo.InvariantCulture, Resources.TinyUrlServiceUri, HttpUtility.UrlEncode(longUrl));
            WebRequest request = HttpWebRequest.Create(requestUrl);

            try
            {
                using (var responseStream = request.GetResponse().GetResponseStream())
                {
                    var reader = new StreamReader(responseStream, Encoding.ASCII);
                    var result = reader.ReadToEnd();
                    result = result.Trim(new[] { ' ', '"' });
                    if (result == "Error")
                    {
                        throw new ArgumentException("Invalid Uri");
                    }

                    return new Uri(result, UriKind.Absolute);
                }
            }
            catch (Exception)
            {
                return null;
            }
        }
    }
}
